/*
 * Copyright (c) 2016, Texas Instruments Incorporated
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * *  Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 *
 * *  Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * *  Neither the name of Texas Instruments Incorporated nor the names of
 *    its contributors may be used to endorse or promote products derived
 *    from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO,
 * THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR
 * CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
 * EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
 * PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS;
 * OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY,
 * WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR
 * OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE,
 * EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 */

/***
 * \file :  test_bluetooth.c
 *
 * \brief: This file contains the Bluetooth handler funstion.
 *
 */

/* Test Routines for SDIO cards on DM814X EVM. */

#include "stdio.h"
#include "sdio.h"
#include "uart.h"
#include "bluetooth.h"

#define TI_MANF_ID		0x000D

/***
 * \brief: Bluetooth test function.
 *
 * \b \Descr: This routine initialize the Bluetooth as well as Respective uart
 * \n         It detedt the card status and read the device ID.
 *
 * \param: VOID
 * \return: SUCCESS  on successful device detection
 *         FAILED   failed to detect the device
 */
STATUS BT_Test
(
	void *testargs
)
{
	STATUS s32status;
#if 0
	s32status = BT_init();
#endif
	UART_Handle handle;
	UINT32 manfid;
	SINT32 err;

	s32status = FAILURE;
	 Uart_stringSend("\r\n==================================="
					 "\r\n         BLUETOOTH Test            "
					 "\r\n===================================\r\n");
	if (DM8127_evm_bt_init() != SUCCESS)
	{
#ifdef DEBUG
		printf ("BT TEST: Unable to initialise BT Chip\n");
		printf ("BT TEST Failed\n");
#else

		Uart_stringSend("\r\nBT chip initialization failed\r\n"
				        "\r\nBT TEST Failed\r\n");
#endif
		return -1;
	}
	
	handle = _UART_open(UART_3, 26); /* 1152000 BAUD */
	UART_EnableHWFlowCntl (handle);
	Uart_stringSend("\r\nDetecting Bluetooth chip");
	err = get_btchip_version (handle, &manfid);
	if (!err)
	{
		if (manfid == TI_MANF_ID) {
#ifdef DEBUG
			printf ("Detected a Texas Instruments BT Chip\n");
			printf ("Detected a BT chip with a ID = 0x%x\n", manfid);
			printf ("BT Test Passed\n");
#else
			Uart_stringSend("\n\rDetected a Texas Instruments BT Chip ");
			platform_write(" with an ID = 0x%x\n\r",manfid);
			Uart_stringSend ("\rChip detectation completed\n\r");
			s32status = SUCCESS;
#endif
		} else
#ifdef DEBUG
			printf ("Detected a BT chip with a ID = 0x08%x\n", manfid);
#else
		platform_write("\nDetected a BT chip with a ID = 0x%x\n\r",manfid);
#endif
		s32status = SUCCESS;
	} else
	{
#ifdef BEBUG
		printf ("BT Test Failed: Unable to communicate with the BT Chip\n");
#else
	printf ("\r\nBT Test Failed: Unable to communicate with the BT Chip\r\n");
#endif
	}
	Uart_stringSend("\r\n-------------------------X-----------------------------");
	return (s32status);
}
